program define table2_dynan

* create a table showing statistics for the highly indebted
* versus others in 2007 
*

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/table2_dynan_$mydate, replace
  capture log close

  file open myfile using "logfiles/table2_dynan_$mydate.txt", write replace
  set more off

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
*  drop if _n > 10000

* create the sample variables:  

  quietly gen temp1 = (wgt>=0 & wgt~=.)
  quietly gen temp4 = ((temp1 + l2.temp1 + l4.temp1) == 3)
  quietly replace temp4 = 0 if yr ~= 2009
  by persid:  egen cons_samp = max(temp4)
  drop temp*

  quietly gen temp1 = reth
  quietly replace temp1 = 0 if yr~=2009 | temp1==.
  by persid:  egen retsamp = max(temp1)
  drop temp1

  quietly gen temp1 = hboom6
  quietly replace temp1 = 0 if hboom6==. 
  by persid:  egen boomsamp = max(temp1)
  drop temp1

  quietly gen temp1 = homeown
  quietly replace temp1 = 0 if yr~=2007 | temp1==.
  by persid:  egen hosamp = max(temp1)
  drop temp1 
 
  gen insamp = cons_samp
  local sss "Sample:  HHs in 2005, 2007, 2009 Waves"

  quietly gen group1 = (insamp==1) & (retsamp==0) & (hosamp==0)  
  quietly gen group2 = (insamp==1) & (retsamp==0) & (hosamp==1) & (boomsamp==0)
  quietly gen group3 = (insamp==1) & (retsamp==0) & (hosamp==1) & (boomsamp==1)

* generate changes

  local vlist d_to_y d_to_a mort_to_hv mort_to_y consxh_to_y networth_to_y nocars mvp_to_y ds_to_y 
  local vlist `vlist' consdbt_to_y adds_alts_to_y

  foreach ddd in 2 4 {
    foreach vvv in `vlist' {
      quietly gen d`ddd'`vvv' = `vvv' - l`ddd'.`vvv'
    }
  }

* generate percent changes

  foreach zzz in 2 4 {
    foreach vvv in consxh_aa myprev hsval tot_fin mort_bal veh_bal_amt oth_dbt networth  {
       quietly gen z`zzz'`vvv' = 100*(`vvv' - l`zzz'.`vvv') / l`zzz'.`vvv'
       quietly replace z`zzz'`vvv' = 100 if z`zzz'`vvv' > 100 & z`zzz'`vvv' ~= . 
       quietly replace z`zzz'`vvv' = -100 if z`zzz'`vvv' < -100 & z`zzz'`vvv' ~= . 
       quietly replace z`zzz'`vvv' = 0 if `vvv'==0 & l`zzz'.`vvv'==0
    }
  }

* generate indicator of someone who became a homeowner

  foreach ddd in 2 4 {
    quietly gen new_ho_`ddd' = homeown - l`ddd'.homeown
    quietly replace new_ho_`ddd' = 0 if new_ho_`ddd' < 0
  } 


* divide income, consumption, and wealth by 1000

  foreach vvv in myprev consxh_aa networth hsval tot_fin mort_bal veh_bal oth_dbt cons_dbt adds_alts {
     quietly replace `vvv' = `vvv'/1000
  }

* TABLE 

  local rowlist hage hcoll myprev consxh_aa nocars networth
  local rowlist `rowlist' hsval tot_fin mort_bal cons_dbt 
  local rowlist `rowlist' consxh_to_y networth_to_y mort_to_y consdbt_to_y 
  local rowlist `rowlist' mort_to_hv ds_to_y
  local rowlist `rowlist' new_ho_2 d2nocars d2consxh_to_y 
  local rowlist `rowlist' d2networth_to_y d2mort_to_y d2mort_to_hv d2consdbt_to_y d2ds_to_y 
  local rowlist `rowlist' zboom_state_hpi state_ur 
	 
  local r1  "2007 Household Characteristics:"
  local r2  "  Head age*"
  local r3  "  Head has college degree*"
  local r4  "  Income/1000"
  local r5  "  Nonhousing cons/1000"
  local r6  "  # of vehicles*"
  local r7  "  Net worth/1000"
  local r8  "    House value/1000"
  local r9  "    Fin assets/1000"
  local r10 "    Mortgage debt/1000"
  local r11 "    Consumer debt/1000"
  local r12 "  Nonhous C/Y"
  local r13 "  NW/Y"
  local r14 "  Mortgage/Y"
  local r15 "  Consumer debt/Y"
  local r16 "  Mortgage/house value"
  local r17 "  Debt service/Y"
  local r18 "Change over previous 2 years:"
  local r19 "  Became homeowner*"
  local r20 "  # of vehicles*"
  local r21 "  Nonhous C/Y"
  local r22 "  NW/Y"
  local r23 "  Mortgage/Y"
  local r24 "  Mortgage/house value"
  local r25 "  Consumer debt/Y"
  local r26 "  Debt service/Y"
  local r27 "Characteristics of 2007 State of Residence:"
  local r28 "  %ch HPI 00-06:"
  local r29 "  Unemployment rate"
  local r30 "Number of observations"

     file write myfile _column(23) "                    Table 2" _n
     file write myfile _column(23) "Comparison between Households who were Highly Indebted" _n
     file write myfile _column(23) "      and Others near Peak of the Credit Boom" _n
     file write myfile _column(23) "   `sss'" _n _n
 
     file write myfile %-20s "     " ///
      _column(29) "Non-homeowners" ///
      _column(47) "  Homeowners" ///
      _column(65) "  Homeowners" /// 
      _n

      file write myfile %-20s "     " ///
      _column(34) " " ///
      _column(46) "In Non-boom States" ///
      _column(64) " In Boom States" /// 
      _n 

      file write myfile %-20s "     " ///
      _column(28) "----------------" ///
      _column(46) "----------------" ///
      _column(64) "----------------" /// 
      _n 

     file write myfile %-20s "     " ///
      _column(28) "High-Debt" ///
      _column(36) "  Other" ///
      _column(46) "High-Debt" ///
      _column(54) "  Other" ///
      _column(64) "High-Debt" ///
      _column(72) "  Other" ///
     _n _n


     * Two possible panels:  top quintiles of D/A and DS/Y
     *   for now, I'm just doing D/A because I worry about sorting on DS/Y
     *   and reporting on DS/Y

       forvalues ppp = 1/1 {
         
         if `ppp' == 1 {
		quietly gen vgroup1 = d_to_a
		quietly gen vgroup2 = mort_to_hv
		quietly gen vgroup3 = mort_to_hv
		*file write myfile %-20s "  " ///
            *      _column(28) "-- Based on Traditional Measure of Leverage --" _n _n
         }
	   if `ppp' == 2 {
		quietly gen vgroup1 = ds_to_y
		quietly gen vgroup2 = ds_to_y
		quietly gen vgroup3 = ds_to_y
		*file write myfile  %-20s "  " ///
            *      _column(28) "-- Based on Ratio of Debt Service Obligations to Income --" _n _n
          }
         * create top quintiles
           foreach ggg in group1 group2 group3 {
             quietly _pctile v`ggg' if yr == 2007 & v`ggg' ~=. & `ggg'==1 [w=wgt], percentiles(80)
             quietly gen tq`ggg' = (v`ggg' >= r(r1)) if yr == 2007 & v`ggg' ~=. & `ggg'==1
             quietly gen oh`ggg' = (v`ggg' < r(r1)) if yr == 2007 & v`ggg' ~=. & `ggg'==1 
           }
           local nnn = 1
           file write myfile %-20s "`r`nnn''" _n 
           local nnn = 2
           foreach rrr in `rowlist' {
              local stat p50
              if inlist("`rrr'","hage","hcoll","nocars","new_ho_2","d2nocars") {
                 local stat mean
               } 
              foreach ggg in group1 group2 group3 {
                 quietly summ `rrr' [w=wgt] if yr==2007 & tq`ggg'==1, detail
                 scalar tq`ggg'_stat = r(`stat')
                 quietly summ `rrr' [w=wgt] if yr==2007 & oh`ggg'==1, detail
                 scalar oh`ggg'_stat = r(`stat')
              }
              file write myfile %-20s "`r`nnn''" ///
                _column(28) %8.2f (tqgroup1_stat)  ///
                _column(36) %8.2f (ohgroup1_stat) ///
                _column(46) %8.2f (tqgroup2_stat)  ///
                _column(54) %8.2f (ohgroup2_stat) ///
                _column(64) %8.2f (tqgroup3_stat)  ///
                _column(72) %8.2f (ohgroup3_stat) ///
                _n
             if inlist(`nnn',17,26) {
                file write myfile _n
                local nnn = `nnn' + 1
                file write myfile %-20s "`r`nnn''" _n
             }
             local nnn = `nnn'+1
          }
   
          foreach ggg in group1 group2 group3 {
            quietly summ hage [w=wgt] if yr==2007 & tq`ggg'==1 
            scalar tq`ggg'_num = r(N)
            quietly summ hage [w=wgt] if yr==2007 & oh`ggg'==1
            scalar oh`ggg'_num = r(N)
          }
	   file write myfile _n
	   file write myfile %-20s "`r`nnn''" ///
	     _column(28) %8.0f (tqgroup1_num)  ///
	     _column(36) %8.0f (ohgroup1_num) ///
	     _column(46) %8.0f (tqgroup2_num)  ///
	     _column(54) %8.0f (ohgroup2_num) ///
	     _column(64) %8.0f (tqgroup3_num)  ///
	     _column(72) %8.0f (ohgroup3_num) ///
	    _n _n

          drop tq* oh* vgroup* 
          }
   file write myfile _n
   file write myfile %-100s "Means shown for variables marked with a *; all other statistics are medians." _n 
   file write myfile %-100a "High debt households (traditional measure) are those in highest quintile of" _n
   file write myfile %-100a "D/A for non-homeowners and of Mortgage/House Value for homeowners." _n
   file write myfile %-100a "High debt payment households are based on total debt service/income for all groups." _n
   file write myfile %-100s "Sample includes only households with a full set of interviews 2005-2009. " _n 
   file write myfile %-100s _n "newpage" _n _n 

  
file close myfile

capture log close

end
